/*	Renegade Scripts.dll
	SSGM crate scripts
	Copyright 2007 Vloktboky, WhiteDragon(MDB), Mac, Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

#include <stdlib.h>
#include <time.h>
#include "scripts.h"
#include "engine.h"
#include "date.h"
#include "gmmain.h"

void CrateSettings::Load() {
	LoadBool(EnableCrates,"EnableCrates");
	LoadBool(EnableNewCrates,"EnableNewCrates");

	if (EnableNewCrates) {
		LoadBool(VehCrate,"AllowVehCrates",false);

		LoadVector3(CrateVehSpawnPos[0],"NodRVC",Vector3(0.0f,0.0f,0.0f),false,true,false);
		LoadVector3(CrateVehSpawnPos[1],"GDIRVC",Vector3(0.0f,0.0f,0.0f),false,true,false);	

		CrateWeapon = INI->Get_Int("Crates","Weapon",0);
		CrateMoney = INI->Get_Int("Crates","Money",0);
		CratePoints = INI->Get_Int("Crates","Points",0);
		CrateVehicle = INI->Get_Int("Crates","Vehicle",0);
		CrateDeath = INI->Get_Int("Crates","Death",0);
		CrateTiberium = INI->Get_Int("Crates","Tiberium",0);
		CrateAmmo = INI->Get_Int("Crates","Ammo",0);
		CrateArmor = INI->Get_Int("Crates","Armor",0);
		CrateHealth = INI->Get_Int("Crates","Health",0);
		CrateCharacter = INI->Get_Int("Crates","Character",0);
		CrateButterFingers = INI->Get_Int("Crates","ButterFingers",0);
		CrateRefill = INI->Get_Int("Crates","Refill",0);
		CrateBeacon = INI->Get_Int("Crates","Beacon",0);
		CrateSpy = INI->Get_Int("Crates","Spy",0);
		CrateStealth = INI->Get_Int("Crates","Stealth",0);
		CrateThief = INI->Get_Int("Crates","Thief",0);
	}
}

char *RandomWeapon[21][3] = {
	{ "Auto	Rifle",	"POW_AutoRifle_Player",	"m00pwar_aqob0004i1evag_snd.wav" },
	{ "Shotgun", "POW_Shotgun_Player", "m00pwps_aqob0004i1evag_snd.wav"	},
	{ "Flamethrower", "POW_Flamethrower_Player", "m00pwft_aqob0001i1evag_snd.wav" },
	{ "Grenade Launcher", "POW_GrenadeLauncher_Player",	"m00pwgl_aqob0004i1evag_snd.wav" },
	{ "Repair Gun(Weak)", "POW_RepairGun_Player", "m00pwrp_aqob0001i1evag_snd.wav" },
	{ "Remote C4", "CnC_POW_MineRemote_02",	"m00pacp_aqob0004i1evag_snd.wav" },
	{ "Chain Gun", "POW_Chaingun_Player", "m00pwcg_aqob0004i1evag_snd.wav" },
	{ "Rocket Launcher(Weak)", "POW_RocketLauncher_Player",	"m00pwrl_aqob0004i1evag_snd.wav" },
	{ "Chemical	Sprayer", "POW_ChemSprayer_Player",	"m00pwcs_aqob0004i1evag_snd.wav" },
	{ "Tiberium	Auto Rifle", "POW_TiberiumAutoRifle_Player", "m00pwtr_aqob0004i1evag_snd.wav" },
	{ "Sniper Rifle", "POW_SniperRifle_Player",	"m00pwsr_aqob0004i1evag_snd.wav" },
	{ "Laser Chaingun",	"POW_LaserChaingun_Player",	"m00pwlc_aqob0004i1evag_snd.wav" },
	{ "Laser Rifle", "POW_LaserRifle_Player", "m00pwlr_aqob0004i1evag_snd.wav" },
	{ "Rocket Launcher(Strong)", "CnC_POW_RocketLauncher_Player", "m00pwrl_aqob0004i1evag_snd.wav" },
	{ "Tiberium	Flechette Gun",	"POW_TiberiumFlechetteGun_Player", "m00pwtf_aqob0004i1evag_snd.wav"	},
	{ "Personal	Ion	Cannon", "POW_PersonalIonCannon_Player", "m00pwpi_aqob0004i1evag_snd.wav" },
	{ "Railgun", "POW_Railgun_Player", "m00pwrg_aqob0004i1evag_snd.wav"	},
	{ "Ramjet Rifle", "POW_RamjetRifle_Player",	"m00pwrj_aqob0004i1evag_snd.wav" },
	{ "Volt	Auto Rifle", "POW_VoltAutoRifle_Player", "m00pwvr_aqob0004i1evag_snd.wav" },
	{ "Volt	Auto Rifle", "CnC_POW_VoltAutoRifle_Player_Nod", "m00pwvr_aqob0004i1evag_snd.wav" }
};

char *RandomVehicle[12][3] = {
	{ "GDI Humvee",	"humvee", "CnC_GDI_Humm-vee" },
	{ "Nod Buggy", "buggy", "CnC_Nod_Buggy" },
	{ "GDI APC", "gdiapc", "CnC_GDI_APC" },
	{ "Nod APC", "nodapc", "CnC_Nod_APC" },
	{ "GDI MRLS", "mrls", "CnC_GDI_MRLS" },
	{ "Nod Mobile Artillery", "arty", "CnC_Nod_Mobile_Artillery"},
	{ "GDI Medium Tank", "med", "CnC_GDI_Medium_Tank" },
	{ "Nod Light Tank",	"lighttank", "CnC_Nod_Light_Tank" },
	{ "Nod Flame Tank",	"flamer", "CnC_Nod_Flame_Tank" },
	{ "Nod Stealth Tank", "stank", "CnC_Nod_Stealth_Tank" },
	{ "GDI Mammoth Tank", "mammy", "CnC_GDI_Mammoth_Tank" },
	{ "Nod Recon Bike",	"recon", "CnC_Nod_Recon_Bike"}
};

char *RandomGDIChar[10][2] = {
	{ "Officer", "CnC_GDI_MiniGunner_1Off" },
	{ "Rocket Soldier",	"CnC_GDI_RocketSoldier_1Off" },
	{ "Sydney",	"CnC_Sydney" },
	{ "Deadeye", "CnC_GDI_MiniGunner_2SF" },
	{ "Gunner",	"CnC_GDI_RocketSoldier_2SF"	},
	{ "Patch", "CnC_GDI_Grenadier_2SF" },
	{ "Havoc", "CnC_GDI_MiniGunner_3Boss" },
	{ "Prototype Sydney", "CnC_Sydney_PowerSuit" },
	{ "Mobius",	"CnC_Ignatio_Mobius" },
	{ "Hotwire", "CnC_GDI_Engineer_2SF"	}
};

char *RandomNodChar[10][2] = {
	{ "Officer", "CnC_Nod_Minigunner_1Off" },
	{ "Rocket Soldier",	"CnC_Nod_RocketSoldier_1Off" },
	{ "Chem	Warrior", "CnC_Nod_FlameThrower_1Off" },
	{ "Blackhand Sniper", "CnC_Nod_Minigunner_2SF" },
	{ "Laser Chaingunner", "CnC_Nod_RocketSoldier_2SF" },
	{ "Stealth Black Hand",	"CnC_Nod_FlameThrower_2SF" },
	{ "Sakura",	"CnC_Nod_Minigunner_3Boss" },
	{ "Raveshaw", "CnC_Nod_RocketSoldier_3Boss"	},
	{ "Mendoza", "CnC_Nod_FlameThrower_3Boss" },
	{ "Technician",	"CnC_Nod_Technician_0" }
};

void Crate_Defaults() {
	Settings->CrateWeapon = 13;
	Settings->CrateMoney = 11;
	Settings->CratePoints = 10;
	Settings->CrateVehicle = 8;
	Settings->CrateDeath = 8;
	Settings->CrateTiberium = 6;
	Settings->CrateAmmo = 5;
	Settings->CrateArmor = 5;
	Settings->CrateHealth = 5;
	Settings->CrateCharacter = 8;
	Settings->CrateButterFingers = 3;
	Settings->CrateSpy = 3;
	Settings->CrateStealth = 3;
	Settings->CrateRefill = 6;
	Settings->CrateBeacon = 4;
	Settings->CrateThief = 2;
}

void Crate_Level_Loaded() {
	int	Total = Settings->CrateDeath + Settings->CrateVehicle + Settings->CrateWeapon + Settings->CrateCharacter + Settings->CrateMoney + Settings->CratePoints + Settings->CrateTiberium + Settings->CrateAmmo + Settings->CrateHealth + Settings->CrateArmor + Settings->CrateRefill + Settings->CrateButterFingers + Settings->CrateSpy + Settings->CrateThief + Settings->CrateBeacon + Settings->CrateStealth;
	if (Total != 100) {
		Crate_Defaults();
		FDSMessage(StrFormat("Total crate percentages equal %d instead of 100. Using default percentages.",Total),"_ERROR");
	}
	Data->CrateLastPickup = -181;
	Data->CrateExists = false;
	Data->CrateID = 0;
}


//******************************************************************************
//*************************** CRATE RELATED SCRIPTS ****************************
//******************************************************************************

//Attached to all crates.
void MDB_SSGM_Crate::Created(GameObject *obj) {
	if (!Settings->EnableCrates	|| Settings->GameMode == 3 || Settings->GameMode ==	4) {
		Commands->Destroy_Object(obj);
	}
	else if (Settings->EnableNewCrates) {
		if (Data->CrateExists || (The_Game()->GameDuration_Seconds - Data->CrateLastPickup) < 180) {
			Commands->Destroy_Object(obj);
		}
		else {
			PickedUp = false;
			Data->CrateExists = true;
			Commands->Set_Model(obj,"vehcol2m");
			Set_Is_Powerup_Persistant(obj,true);
			Set_Powerup_Always_Allow_Grant(obj,true);
			Set_Powerup_Grant_Sound(obj,0);
		}
	}
	else {
		Destroy_Script();
	}	
}

void MDB_SSGM_Crate::Custom(GameObject *obj,	int	message, int param,	GameObject *sender) {
	if (message	== 1000000025 && !PickedUp) {
		if (Settings->VehCrate || !Get_Vehicle(sender)) {
			int Team = Get_Object_Type(sender);
			if (Team > 1 || Team < 0) {
				return;
			}

			PickedUp = true;
			Data->CrateLastPickup = The_Game()->GameDuration_Seconds;
			Data->CrateExists = false;

			std::string message1; //Console_Input
			std::string message2; //FDSMessage
			std::string message3; //WriteGamelog

			CrateStart:
			int RandomIntCrate = Commands->Get_Random_Int(1,101);
			int	percent	= 0;
			if ((RandomIntCrate	<= (percent+=Settings->CrateWeapon)) && (Settings->CrateWeapon > 0)) {
				Reselect:
				int	Rnd	= Commands->Get_Random_Int(1,101);
				int	Index = 0;
				if (Rnd	<= 10) Index = 0;
				else if	(Rnd<=20) Index	= 1;
				else if	(Rnd<=30) Index	= 2;
				else if	(Rnd<=40) Index	= 3;
				else if	(Rnd<=50) Index	= 4;
				else if	(Rnd<=60) Index	= 5;
				else if	(Rnd<=65) Index	= 6;
				else if	(Rnd<=70) Index	= 7;
				else if	(Rnd<=75) Index	= 8;
				else if	(Rnd<=80) Index	= 9;
				else if	(Rnd<=82) Index	= 10;
				else if	(Rnd<=84) Index	= 11;
				else if	(Rnd<=86) Index	= 12;
				else if	(Rnd<=88) Index	= 13;
				else if	(Rnd<=90) Index	= 14;
				else if	(Rnd<=92) Index	= 15;
				else if	(Rnd<=94) Index	= 16;
				else if	(Rnd<=96) Index	= 17;
				else if	(Rnd<=98) Index	= 18;
				else Index = 19;
				if (Settings->Is_Disabled(RandomWeapon[Index][1])) goto Reselect;
				Commands->Give_Powerup(sender,RandomWeapon[Index][1],true);
				if (RandomWeapon[Index][2][0] != '\0') {
					Create_2D_WAV_Sound_Player(sender,RandomWeapon[Index][2]);
				}
				StrFormat2(message1,"ppage %d [Crate] You just got a %s from the Random Weapon Crate.",Get_Player_ID(sender),RandomWeapon[Index][0]);
				StrFormat2(message2,"%ls picked up a Random Weapon Crate.",Get_Wide_Player_Name(sender));
				if (Settings->Gamelog) {
					Vector3 pos	= Commands->Get_Position(sender);
					StrFormat2(message3,"CRATE;WEAPON;%s;%d;%s;%f;%f;%f;%f;%f;%f;%d",RandomWeapon[Index][0],Commands->Get_ID(sender),Commands->Get_Preset_Name(sender),pos.Y,pos.X,pos.Z,Commands->Get_Facing(sender),Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
				}
			}
			else if	((RandomIntCrate <=	(percent+=Settings->CrateMoney))	&& (Settings->CrateMoney	> 0)) {
				int	Amount = Commands->Get_Random_Int(1,1000);
				int	RndGood	= Commands->Get_Random_Int(1,2);
				if (RndGood	== 1) {
					Commands->Give_Money(sender,(float)Amount,false);
					Create_2D_WAV_Sound_Player(sender,"m00pc$$_aqob0002i1evag_snd.wav");
				}
				else {
					Commands->Give_Money(sender,(float)(Amount*-1),false);
					if (Commands->Get_Money(sender)	< 0) Commands->Give_Money(sender,(Commands->Get_Money(sender) *	-1),false);
				}
				if (RndGood == 1) {
					StrFormat2(message1,"ppage %d [Crate] You just got the Money Crate, you have gained %d credits.",Get_Player_ID(sender),(int)Amount);
					StrFormat2(message2,"%ls picked up a Money Crate.",Get_Wide_Player_Name(sender));
					if (Settings->Gamelog) {
						Vector3 pos = Commands->Get_Position(obj);
						StrFormat2(message3,"CRATE;MONEY;%d;%d;%s;%f;%f;%f;%f;%f;%f;%d", int(Amount),	Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z,	Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					}
				}
				else {
					StrFormat2(message1,"ppage %d [Crate] You just got the Demoney Crate, you have lost %d credits.",Get_Player_ID(sender),(int)Amount);
					StrFormat2(message2,"%ls picked up a Demoney Crate.",Get_Wide_Player_Name(sender));
					if (Settings->Gamelog) {
						Vector3 pos = Commands->Get_Position(obj);
						StrFormat2(message3,"CRATE;MONEY;%d;%d;%s;%f;%f;%f;%f;%f;%f;%d", int(Amount) * -1, Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					}
				}			
			}
			else if	((RandomIntCrate <=	(percent+=Settings->CratePoints)) &&	(Settings->CratePoints >	0)) {
				int	Amount = Commands->Get_Random_Int(1,500);
				int	RndGood	= Commands->Get_Random_Int(1,2);
				if (RndGood	== 1) {
					Commands->Give_Points(sender,(float)Amount,false);
				}
				else {
					Commands->Give_Points(sender,(float)(Amount*-1),false);
				}

				if (RndGood == 1) {
					StrFormat2(message2,"%ls picked up a Points Crate.",Get_Wide_Player_Name(sender));
					StrFormat2(message1,"ppage %d [Crate] You just got the Points Crate, you have gained %d points.",Get_Player_ID(sender),(int)Amount);
					Console_Input(StrFormat("msg Crate: Enjoy those %d points from the crate god, %ls.",(int)Amount,Get_Wide_Team_Name(Team)).c_str());
					if (Settings->Gamelog) {
						Vector3	pos	= Commands->Get_Position(sender);
						StrFormat2(message3,"CRATE;POINTS;%d;%d;%s;%f;%f;%f;%f;%f;%f;%d",int(Amount), Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					}
				}
				else {
					StrFormat2(message2,"%ls picked up a Depoints Crate.",Get_Wide_Player_Name(sender));
					StrFormat2(message1,"ppage %d [Crate] You just got the Depoints Crate, you lost %d points.",Get_Player_ID(sender),(int)Amount);
					Console_Input(StrFormat("msg Crate: Hope you won't miss those %d points, %ls.",(int)Amount,Get_Wide_Team_Name(Team)).c_str());
					if (Settings->Gamelog) {
						Vector3	pos	= Commands->Get_Position(sender);
						StrFormat2(message3,"CRATE;POINTS;%d;%d;%s;%f;%f;%f;%f;%f;%f;%d",int(Amount)	* -1, Commands->Get_ID(sender),	Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender),	Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					}
				}		
			}
			else if	((RandomIntCrate <=	(percent+=Settings->CrateVehicle)) && (Settings->CrateVehicle	> 0)) {
				if (Get_Vehicle(sender) || Settings->GameMode != 1 || Settings->CrateVehSpawnPos[0].X == 0.0f || Settings->CrateVehSpawnPos[0].Y == 0.0f || Settings->CrateVehSpawnPos[0].Z == 0.0f || Settings->CrateVehSpawnPos[1].X == 0.0f || Settings->CrateVehSpawnPos[1].Y == 0.0f || Settings->CrateVehSpawnPos[1].Z == 0.0f) {
					goto CrateStart;
				}
				Vector3	Pos = Settings->CrateVehSpawnPos[Get_Object_Type(sender)];
				Damage_All_Vehicles_Area(999999.0f,"Laser_NoBuilding",Pos,2.0f,obj,0);
				Commands->Set_Position(sender,Pos);

				GameObject *Temp = Commands->Create_Object("Invisible_Object",Pos);
				Reselect2:
				int	Rnd	= Commands->Get_Random_Int(1,201);
				int	Index = 0;
				if (Rnd	<= 25) Index = 0;
				else if	(Rnd <=	50)	Index =	1;
				else if	(Rnd <=	70)	Index =	2;
				else if	(Rnd <=	90)	Index =	3;
				else if	(Rnd <=	110) Index = 4;
				else if	(Rnd <=	130) Index = 5;
				else if	(Rnd <=	145) Index = 6;
				else if	(Rnd <=	160) Index = 7;
				else if	(Rnd <=	170) Index = 8;
				else if	(Rnd <=	180) Index = 9;
				else if	(Rnd <=	190) Index = 10;
				else Index = 11;
				if (Settings->Is_Disabled(RandomVehicle[Index][2])) goto Reselect2;		
				StrFormat2(message2,"%ls picked up a Random Vehicle Crate.",Get_Wide_Player_Name(sender));
				StrFormat2(message1,"ppage %d [Crate] You got a %s from the Random Vehicle Crate.",Get_Player_ID(sender), RandomVehicle[Index][0]);
				Commands->Attach_Script(Temp,"Test_Cinematic",StrFormat("%sRVC_%s.txt",Commands->Get_Player_Type(sender)	== 0?"Nod":"GDI",RandomVehicle[Index][1]).c_str());
				Console_Input(StrFormat("msg Crate: Looks like %ls just got a random vehicle! Go them!",Get_Wide_Team_Name(Team)).c_str());
				if (Settings->Gamelog) {
					Vector3 pos = Commands->Get_Position(sender);
					StrFormat2(message3,"CRATE;VEHICLE;%s;%d;%s;%f;%f;%f;%f;%f;%f;%d", RandomVehicle[Index][0], Commands->Get_ID(sender),	Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender),	Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
				}	
			}
			else if	((RandomIntCrate <=	(percent+=Settings->CrateDeath))	&& (Settings->CrateDeath	> 0)) {
				StrFormat2(message2,"%ls picked up a Death Crate.",Get_Wide_Player_Name(sender));
				Commands->Apply_Damage(Get_Vehicle(sender),99999,"Shrapnel",0);
				Commands->Apply_Damage(sender,99999,"Shrapnel",0);
				Commands->Create_Explosion("Explosion_Mine_Proximity_01",Commands->Get_Position(obj),0);
				StrFormat2(message1,"ppage %d [Crate] You just got a Death Crate, you have been killed. Sorry :(",Get_Player_ID(sender));
				Console_Input(StrFormat("msg Crate: Some poor %ls guy got pwned by the fearsome death crate!!",Get_Wide_Team_Name(Team)).c_str());
				if (Settings->Gamelog)  {
					Vector3	pos;
					pos	= Commands->Get_Position(sender);
					StrFormat2(message3,"CRATE;DEATH;;%d;%s;%f;%f;%f;%f;%f;%f;%d", Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
				}
			}
			else if	((RandomIntCrate <=	(percent+=Settings->CrateTiberium)) && (Settings->CrateTiberium >	0)) {
				StrFormat2(message2,"%ls picked up a Tiberium Death Crate.",Get_Wide_Player_Name(sender));
				Commands->Apply_Damage(Get_Vehicle(sender),99999,"Shrapnel",0);
				Commands->Apply_Damage(sender,99999,"TiberiumRaw",false);
				Commands->Create_Object("CnC_Visceroid",Commands->Get_Position(sender));
				StrFormat2(message1,"ppage %d [Crate] You have been killed by the tiberium death crate and your remains mutated into a visceroid.",Get_Player_ID(sender));
				Commands->Create_2D_WAV_Sound("m00evag_dsgn0027i1evag_snd.wav");
				if (Settings->Gamelog) {
					Vector3	pos	= Commands->Get_Position(sender);
					StrFormat2(message3,"CRATE;TIBERIUMDEATH;;%d;%s;%f;%f;%f;%f;%f;%f;%d", Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
				}
			}
			else if	((RandomIntCrate <=	(percent+=Settings->CrateAmmo)) && (Settings->CrateAmmo > 0)) {
				Commands->Give_Powerup(sender,"CnC_POW_Ammo_ClipMax",false);
				Commands->Give_Powerup(sender,"CnC_POW_Ammo_ClipMax",false);
				Commands->Give_Powerup(sender,"CnC_POW_Ammo_ClipMax",false);
				Commands->Give_Powerup(sender,"CnC_POW_Ammo_ClipMax",false);
				StrFormat2(message2,"%ls picked up a Full Ammo Crate.",Get_Wide_Player_Name(sender));
				StrFormat2(message1,"ppage %d [Crate] You just got the Full Ammo Crate, your ammo has been refilled.",Get_Player_ID(sender));
				Create_2D_WAV_Sound_Player(sender,"m00puar_aqob0002i1evag_snd.wav");
				if (Settings->Gamelog) {
					Vector3	pos	= Commands->Get_Position(sender);
					StrFormat2(message3,"CRATE;FULLAMMO;;%d;%s;%f;%f;%f;%f;%f;%f;%d", Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z,	Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
				}
			}
			else if	((RandomIntCrate <=	(percent+=Settings->CrateArmor)) && (Settings->CrateArmor > 0)) {
				int	RndGood	= Commands->Get_Random_Int(1,3);
				if (Commands->Get_Shield_Strength(sender) <	2) RndGood = 1;
				if (RndGood	== 1) {
					Commands->Give_Powerup(sender,"POW_Medal_Armor",true);
					StrFormat2(message2,"%ls picked up an Armor Crate.",Get_Wide_Player_Name(sender));
					StrFormat2(message1,"ppage %d [Crate] You just got the Armor Crate, your max armor has been increased!",Get_Player_ID(sender));
					if (Settings->Gamelog) {
						Vector3	pos	= Commands->Get_Position(sender);
						StrFormat2(message3,"CRATE;ARMORINCREASE;;%d;%s;%f;%f;%f;%f;%f;%f;%d", Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					}
				}
				else {
					Commands->Set_Shield_Strength(sender,1);
					StrFormat2(message2,"%ls picked up a Dearmor Crate.",Get_Wide_Player_Name(sender));
					StrFormat2(message1,"ppage %d [Crate] You just got the Dearmor Crate, your armor has been set to 1.",Get_Player_ID(sender));
					if (Settings->Gamelog) {
						Vector3	pos	= Commands->Get_Position(sender);
						StrFormat2(message3,"CRATE;ARMORLOST;;%d;%s;%f;%f;%f;%f;%f;%f;%d", Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					}
				}
			}
			else if	((RandomIntCrate <=	(percent+=Settings->CrateHealth)) &&	(Settings->CrateHealth >	0)) {
				int	RndGood	= Commands->Get_Random_Int(1,3);
				if (Commands->Get_Health(sender) ==	1) RndGood = 1;
				if (RndGood	== 1) {
					Commands->Give_Powerup(sender,"POW_Medal_Health",true);
					StrFormat2(message2,"%ls picked up a Health Crate.",Get_Wide_Player_Name(sender));
					StrFormat2(message1,"ppage %d [Crate] You just got the Health Crate, your max health has been increased!",Get_Player_ID(sender));
					if (Settings->Gamelog)  {
						Vector3	pos	= Commands->Get_Position(sender);
						StrFormat2(message3,"CRATE;HEALTHUPGRADE;;%d;%s;%f;%f;%f;%f;%f;%f;%d", Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					}
				}
				else {
					Commands->Set_Health(sender,1);
					StrFormat2(message2,"%ls picked up a Dehealth Crate.",Get_Wide_Player_Name(sender));
					StrFormat2(message1,"ppage %d [Crate] You just got the Dehealth Crate, your health has been set to 1.",Get_Player_ID(sender));
					Create_2D_WAV_Sound_Player(sender,"m00evag_dsgn0026i1evag_snd.wav");
					if (Settings->Gamelog) {
						Vector3 pos = Commands->Get_Position(sender);
						StrFormat2(message3,"CRATE;HEALTHREDUCE;;%d;%s;%f;%f;%f;%f;%f;%f;%d",	Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z,	Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					}
				}
			}
			else if	((RandomIntCrate <=	(percent+=Settings->CrateCharacter))	&& (Settings->CrateCharacter	> 0)) {
				if (Get_Vehicle(sender) || Settings->GameMode == 3 || Settings->GameMode == 4) {
					goto CrateStart;
				}
				Reselect3:
				int	Rnd	= Commands->Get_Random_Int(1,101);
				int	Index = 0;
				if (Rnd	<= 20) Index = 0;
				else if	(Rnd <=	40)	Index =	1;
				else if	(Rnd <=	50)	Index =	2;
				else if	(Rnd <=	60)	Index =	3;
				else if	(Rnd <=	70)	Index =	4;
				else if	(Rnd <=	80)	Index =	5;
				else if	(Rnd <=	85)	Index =	6;
				else if	(Rnd <=	90)	Index =	7;
				else if	(Rnd <=	95)	Index =	8;
				else Index = 9;
				if (Team == 1 && Settings->Is_Disabled(RandomGDIChar[Index][1])) {
					goto Reselect3;
				}
				else if (Team == 0 && Settings->Is_Disabled(RandomNodChar[Index][1])) {
					goto Reselect3;
				}
				StrFormat2(message2,"%ls picked up a Random Character Crate.",Get_Wide_Player_Name(sender));
				if (Commands->Get_Player_Type(sender) == 1) {
					Change_Character(sender,RandomGDIChar[Index][1]);
					StrFormat2(message1,"ppage %d [Crate] You have been transformed into a %s by the Random Character Crate.",Get_Player_ID(sender),RandomGDIChar[Index][0]);
					if (Settings->Gamelog)  {
						Vector3	pos	= Commands->Get_Position(sender);
						StrFormat2(message3,"CRATE;CHARACTER;%s;%d;%s;%f;%f;%f;%f;%f;%f;%d", RandomGDIChar[Index][0],	Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z,	Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					}
				}
				else {
					Change_Character(sender,RandomNodChar[Index][1]);
					StrFormat2(message1,"ppage %d [Crate] You have been transformed into a %s by the Random Character Crate.",Get_Player_ID(sender),RandomNodChar[Index][0]);
					if (Settings->Gamelog)  {
						Vector3	pos	= Commands->Get_Position(sender);
						StrFormat2(message3,"CRATE;CHARACTER;%s;%d;%s;%f;%f;%f;%f;%f;%f;%d", RandomNodChar[Index][0],	Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z,	Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					}
				}
			}
			else if	((RandomIntCrate <=	(percent+=Settings->CrateButterFingers))	&& (Settings->CrateButterFingers	> 0)) {
				Commands->Clear_Weapons(sender);
				int	Rnd	= Commands->Get_Random_Int(1,3);
				if (Rnd	== 1) {
					Commands->Give_Powerup(sender,"POW_Pistol_Player",false);
					Commands->Select_Weapon(sender,"Weapon_Pistol_Player");
				}
				else {
					Commands->Give_Powerup(sender,"CnC_POW_MineTimed_Player_01",false);
					Commands->Select_Weapon(sender,"CnC_Weapon_MineTimed_Player");
				}
				StrFormat2(message2,"%ls picked up the Butter Fingers Crate.",Get_Wide_Player_Name(sender));
				StrFormat2(message1,"ppage %d [Crate] You picked up the Butter Fingers Crate, you have dropped most of your weapons.",Get_Player_ID(sender));
				if (Settings->Gamelog) {
					Vector3	pos	= Commands->Get_Position(sender);
					StrFormat2(message3,"CRATE;BUTTERFINGER;;%d;%s;%f;%f;%f;%f;%f;%f;%d",Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z,	Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
				}
			}
			else if	((RandomIntCrate <=	(percent+=Settings->CrateRefill)) &&	(Settings->CrateRefill >	0)) {
				Grant_Refill(sender);
				StrFormat2(message2,"%ls picked up the Refill Crate.",Get_Wide_Player_Name(sender));
				StrFormat2(message1,"ppage %d [Crate] You just got the Refill Crate, your health, armor, and ammo have all been refilled.",Get_Player_ID(sender));
				Create_2D_WAV_Sound_Player(sender,"m00puar_aqob0002i1evag_snd.wav");
				if (Settings->Gamelog) {
					Vector3	pos	= Commands->Get_Position(sender);
					StrFormat2(message3,"CRATE;REFILL;;%d;%s;%f;%f;%f;%f;%f;%f;%d", Commands->Get_ID(sender),	Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender),	Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
				}
			}
			else if	((RandomIntCrate <=	(percent+=Settings->CrateBeacon)) &&	(Settings->CrateBeacon >	0)) {
				if (Settings->DisableBeacons ||	Settings->GameMode == 2 || Settings->GameMode == 3 || Settings->GameMode == 4) {
					goto CrateStart;
				}
				int	RndGood	= Commands->Get_Random_Int(1,3);
				if (RndGood	== 1) {
					StrFormat2(message2,"%ls picked up a Beacon Crate.",Get_Wide_Player_Name(sender));
					if (Commands->Get_Player_Type(sender) == 1) {
						TeamPurchaseSettingsDefClass *PT = TeamPurchaseSettingsDefClass::Get_Definition(0);
						Commands->Give_Powerup(sender,Get_Definition_Name(PT->beaconpresetid),true);
						StrFormat2(message1,"ppage %d [Crate] You just got the Beacon Crate, you have been given an Ion Cannon Beacon.",Get_Player_ID(sender));
						Create_2D_Sound_Player(sender,"m00evag_dsgn0070i1evag_snd.wav");
					}
					else if	(Commands->Get_Player_Type(sender) == 0) {
						TeamPurchaseSettingsDefClass *PT = TeamPurchaseSettingsDefClass::Get_Definition(1);
						Commands->Give_Powerup(sender,Get_Definition_Name(PT->beaconpresetid),true);
						StrFormat2(message1,"ppage %d [Crate] You just got the Beacon Crate, you have been given a Nuclear Strike Beacon.",Get_Player_ID(sender));
						Create_2D_Sound_Player(sender,"m00evan_dsgn0074i1evan_snd.wav");
					}
					if (Settings->Gamelog) {
						Vector3	pos	= Commands->Get_Position(sender);
						StrFormat2(message3,"CRATE;BEACON;;%d;%s;%f;%f;%f;%f;%f;%f;%d", Commands->Get_ID(sender),	Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender),	Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					}
				}
				else {
					Commands->Create_Object("Beacon_Nuke_Strike_Anim_Post",Commands->Get_Position(obj));
					Commands->Create_Explosion("Explosion_NukeBeacon",Commands->Get_Position(obj),0);
					Damage_All_Objects_Area(2500.0f,"None",Commands->Get_Position(obj),15.0f,obj,0);
					StrFormat2(message2,"%ls picked up a Nuclear Bomb Crate.",Get_Wide_Player_Name(sender));
					StrFormat2(message1,"ppage %d [Crate] You just got a Nuclear Bomb Crate, you have been killed. Sorry :(",Get_Player_ID(sender));
					Console_Input(StrFormat("msg Crate: Looks like a %ls player just got blown to bits by a Nuclear Bomb.",Get_Wide_Team_Name(Team)).c_str());
					if (Settings->Gamelog)  {
						Vector3	pos	= Commands->Get_Position(sender);
						StrFormat2(message3,"CRATE;BEACONDEATH;;%d;%s;%f;%f;%f;%f;%f;%f;%d", Commands->Get_ID(sender), Commands->Get_Preset_Name(sender),	pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					}
				}
			}
			else if	((RandomIntCrate <=	(percent+=Settings->CrateSpy)) && (Settings->CrateSpy > 0)) {
				if (Settings->GameMode != 1) goto CrateStart;
				Change_Character(sender,"CnC_Nod_FlameThrower_2SF");
				Commands->Set_Is_Visible(sender,false);
				StrFormat2(message2,"A %ls player picked up a Spy Crate.",Get_Wide_Team_Name(Team));
				StrFormat2(message1,"ppage %d [Crate] You got the Spy Crate, base defenses will ignore you until you die, buy a new character or destroy a building.",Get_Player_ID(sender));
				Console_Input(StrFormat("msg Crate: Oh no! A %ls player just got a spy crate, better watch your base %ls!",Get_Wide_Team_Name(Team),Get_Wide_Team_Name(PTTEAM(Team))).c_str());
				if (Settings->Gamelog)  {
					Vector3 pos	= Commands->Get_Position(sender);
					StrFormat2(message3,"CRATE;SPY;;0;0;%f;%f;%f;%f;%f;%f;%d",pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
				}
			}
			else if	((RandomIntCrate <=	(percent+=Settings->CrateStealth)) && (Settings->CrateStealth	> 0)) {
				Commands->Enable_Stealth(sender,true);
				StrFormat2(message2,"%ls picked up a Stealth Crate.",Get_Wide_Player_Name(sender));
				StrFormat2(message1,"ppage %d [Crate] You got the stealth crate! You have been given a stealth suit.",Get_Player_ID(sender));
				if (Settings->Gamelog) {
					Vector3	pos	= Commands->Get_Position(sender);
					StrFormat2(message3,"CRATE;STEALTH;;%d;%s;%f;%f;%f;%f;%f;%f;%d", Commands->Get_ID(sender), Commands->Get_Preset_Name(sender),	pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
				}
			}
			else if	((RandomIntCrate <=	(percent+=Settings->CrateThief))	&& (Settings->CrateThief	> 0)) {
				Commands->Give_Money(sender,(Commands->Get_Money(sender) * -1),false);
				StrFormat2(message2,"%ls picked up a Thief Crate.",Get_Wide_Player_Name(sender));
				StrFormat2(message1,"ppage %d [Crate] You got the Thief Crate, you have lost all of your credits.",Get_Player_ID(sender));
				Create_2D_Sound_Player(sender,"m00evag_dsgn0028i1evag_snd.wav");
				if (Settings->Gamelog) {
					Vector3	pos	= Commands->Get_Position(sender);
					StrFormat2(message3,"CRATE;THIEF;;%d;%s;%f;%f;%f;%f;%f;%f;%d", Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
				}
			}
			else {
				goto CrateStart;
			}
			Console_Input(message1.c_str());
			FDSMessage(message2,"_CRATE");
			if (Settings->Gamelog) {
				WriteGamelog(message3);
			}
			Commands->Destroy_Object(obj);
		}
	}
}

void KAK_Prevent_Destruction_Until_Entered::Created(GameObject *obj) {
	Commands->Set_Player_Type(obj,-2);
	Commands->Start_Timer(obj,this,30,1);
}

void KAK_Prevent_Destruction_Until_Entered::Damaged(GameObject *obj, GameObject *damager, float damage) {
	Commands->Set_Health(obj,Commands->Get_Max_Health(obj));
	Commands->Set_Shield_Strength(obj,Commands->Get_Max_Shield_Strength(obj));
}

void KAK_Prevent_Destruction_Until_Entered::Custom(GameObject *obj, int message, int param, GameObject *sender) {
	if (message == CUSTOM_EVENT_VEHICLE_ENTER) {
		Destroy_Script();
	}
}

void KAK_Prevent_Destruction_Until_Entered::Timer_Expired(GameObject *obj, int number) {
	if (number == 1) {
		Destroy_Script();
	}
}

ScriptRegistrant<MDB_SSGM_Crate> MDB_SSGM_Crate_Registrant("MDB_SSGM_Crate","");
ScriptRegistrant<KAK_Prevent_Destruction_Until_Entered>	KAK_Prevent_Destruction_Until_Entered_Registrant("KAK_Prevent_Destruction_Until_Entered","");

